/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.generator;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2246;
import net.minecraft.class_2378;
import net.minecraft.class_2794;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3754;
import net.minecraft.class_5216;
import net.minecraft.class_5284;
import net.minecraft.class_5285;
import net.minecraft.class_5309;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_5458;
import net.minecraft.class_5485;
import net.minecraft.class_6725;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_6910;
import net.minecraft.class_6954;
import net.minecraft.class_7059;
import net.minecraft.class_7138;
import net.minecraft.class_7510;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.levelgen.LevelGenUtil;
import org.betterx.bclib.config.Configs;
import org.betterx.bclib.interfaces.ChunkGeneratorAccessor;
import org.betterx.bclib.interfaces.NoiseGeneratorSettingsProvider;
import org.betterx.worlds.together.WorldsTogether;
import org.betterx.worlds.together.biomesource.MergeableBiomeSource;
import org.betterx.worlds.together.biomesource.ReloadableBiomeSource;
import org.betterx.worlds.together.chunkgenerator.EnforceableChunkGenerator;
import org.betterx.worlds.together.chunkgenerator.InjectableSurfaceRules;
import org.betterx.worlds.together.chunkgenerator.RestorableBiomeSource;
import org.betterx.worlds.together.world.BiomeSourceWithNoiseRelatedSettings;

public class BCLChunkGenerator
extends class_3754
implements RestorableBiomeSource<BCLChunkGenerator>,
InjectableSurfaceRules<BCLChunkGenerator>,
EnforceableChunkGenerator<BCLChunkGenerator> {
    public static final Codec<BCLChunkGenerator> CODEC = RecordCodecBuilder.create(builderInstance -> {
        RecordCodecBuilder noiseGetter = class_6903.method_40419((class_5321)class_2378.field_35433).forGetter(BCLChunkGenerator::getNoises);
        RecordCodecBuilder biomeSourceCodec = class_1966.field_24713.fieldOf("biome_source").forGetter(generator -> generator.field_12761);
        RecordCodecBuilder settingsCodec = class_5284.field_24781.fieldOf("settings").forGetter(generator -> generator.field_24774);
        return class_3754.method_41042((RecordCodecBuilder.Instance)builderInstance).and(builderInstance.group((App)noiseGetter, (App)biomeSourceCodec, (App)settingsCodec)).apply((Applicative)builderInstance, builderInstance.stable(BCLChunkGenerator::new));
    });
    protected static final class_5309 NETHER_NOISE_SETTINGS_AMPLIFIED = class_5309.method_32994((int)0, (int)256, (int)1, (int)4);
    public static final class_5321<class_5284> AMPLIFIED_NETHER = class_5321.method_29179((class_5321)class_2378.field_26374, (class_2960)BCLib.makeID("amplified_nether"));
    public final class_1966 initialBiomeSource;

    public BCLChunkGenerator(class_2378<class_7059> registry, class_2378<class_5216.class_5487> registry2, class_1966 biomeSource, class_6880<class_5284> holder) {
        super(registry, registry2, biomeSource, holder);
        this.initialBiomeSource = biomeSource;
        if (biomeSource instanceof BiomeSourceWithNoiseRelatedSettings) {
            BiomeSourceWithNoiseRelatedSettings bcl = (BiomeSourceWithNoiseRelatedSettings)biomeSource;
            bcl.onLoadGeneratorSettings((class_5284)holder.comp_349());
        }
        if (WorldsTogether.RUNS_TERRABLENDER) {
            if (Configs.MAIN_CONFIG.verboseLogging()) {
                BCLib.LOGGER.info("Make sure features are loaded from terrablender" + biomeSource);
            }
            this.rebuildFeaturesPerStep(biomeSource);
        }
    }

    private void rebuildFeaturesPerStep(class_1966 biomeSource) {
        BCLChunkGenerator bCLChunkGenerator = this;
        if (bCLChunkGenerator instanceof org.betterx.bclib.mixin.common.ChunkGeneratorAccessor) {
            org.betterx.bclib.mixin.common.ChunkGeneratorAccessor acc = (org.betterx.bclib.mixin.common.ChunkGeneratorAccessor)((Object)bCLChunkGenerator);
            Function<class_6880, class_5485> function = hh -> ((class_1959)hh.comp_349()).method_30970();
            acc.bcl_setFeaturesPerStep((Supplier<List<class_7510.class_6827>>)Suppliers.memoize(() -> class_7510.method_44210(List.copyOf(biomeSource.method_28443()), hh -> ((class_5485)function.apply((class_6880)hh)).method_30983(), (boolean)true)));
        }
    }

    @Override
    public void restoreInitialBiomeSource(class_5321<class_5363> dimensionKey) {
        BCLChunkGenerator bCLChunkGenerator;
        if (this.initialBiomeSource != this.method_12098() && (bCLChunkGenerator = this) instanceof org.betterx.bclib.mixin.common.ChunkGeneratorAccessor) {
            org.betterx.bclib.mixin.common.ChunkGeneratorAccessor acc = (org.betterx.bclib.mixin.common.ChunkGeneratorAccessor)((Object)bCLChunkGenerator);
            class_1966 class_19662 = this.initialBiomeSource;
            if (class_19662 instanceof MergeableBiomeSource) {
                MergeableBiomeSource bs = (MergeableBiomeSource)class_19662;
                acc.bcl_setBiomeSource((class_1966)bs.mergeWithBiomeSource(this.method_12098()));
            } else {
                class_19662 = this.initialBiomeSource;
                if (class_19662 instanceof ReloadableBiomeSource) {
                    ReloadableBiomeSource bs = (ReloadableBiomeSource)class_19662;
                    bs.reloadBiomes();
                }
            }
            this.rebuildFeaturesPerStep(this.method_12098());
        }
    }

    protected Codec<? extends class_2794> method_28506() {
        return CODEC;
    }

    private class_2378<class_5216.class_5487> getNoises() {
        BCLChunkGenerator bCLChunkGenerator = this;
        if (bCLChunkGenerator instanceof NoiseGeneratorSettingsProvider) {
            NoiseGeneratorSettingsProvider p = (NoiseGeneratorSettingsProvider)((Object)bCLChunkGenerator);
            return p.bclib_getNoises();
        }
        return null;
    }

    public String toString() {
        return "BCLib - Chunk Generator (" + Integer.toHexString(this.hashCode()) + ")";
    }

    public void appendFeaturesPerStep() {
    }

    public static class_7138 createRandomState(class_3218 level, class_2794 generator) {
        if (generator instanceof class_3754) {
            class_3754 noiseBasedChunkGenerator = (class_3754)generator;
            return class_7138.method_41556((class_5284)((class_5284)noiseBasedChunkGenerator.method_41541().comp_349()), (class_2378)level.method_30349().method_30530(class_2378.field_35433), (long)level.method_8412());
        }
        return class_7138.method_41557((class_5455)level.method_30349(), (class_5321)class_5284.field_26355, (long)level.method_8412());
    }

    @Override
    public class_5285 enforceGeneratorInWorldGenSettings(class_5455 access, class_5321<class_5363> dimensionKey, class_5321<class_2874> dimensionTypeKey, class_2794 loadedChunkGenerator, class_5285 settings) {
        BCLib.LOGGER.info("Enforcing Correct Generator for " + dimensionKey.method_29177().toString() + ".");
        BCLChunkGenerator referenceGenerator = this;
        if (loadedChunkGenerator instanceof ChunkGeneratorAccessor) {
            ChunkGeneratorAccessor generator = (ChunkGeneratorAccessor)loadedChunkGenerator;
            if (loadedChunkGenerator instanceof NoiseGeneratorSettingsProvider) {
                NoiseGeneratorSettingsProvider noiseProvider = (NoiseGeneratorSettingsProvider)loadedChunkGenerator;
                if (referenceGenerator instanceof NoiseGeneratorSettingsProvider) {
                    Object bs;
                    NoiseGeneratorSettingsProvider referenceProvider = (NoiseGeneratorSettingsProvider)((Object)referenceGenerator);
                    class_1966 class_19662 = referenceGenerator.method_12098();
                    if (class_19662 instanceof MergeableBiomeSource) {
                        MergeableBiomeSource mbs = (MergeableBiomeSource)class_19662;
                        bs = mbs.mergeWithBiomeSource(loadedChunkGenerator.method_12098());
                    } else {
                        bs = referenceGenerator.method_12098();
                    }
                    referenceGenerator = new BCLChunkGenerator(generator.bclib_getStructureSetsRegistry(), noiseProvider.bclib_getNoises(), (class_1966)bs, BCLChunkGenerator.buildGeneratorSettings(referenceProvider.bclib_getNoiseGeneratorSettingHolders(), noiseProvider.bclib_getNoiseGeneratorSettingHolders(), bs));
                }
            }
        }
        return LevelGenUtil.replaceGenerator(dimensionKey, dimensionTypeKey, access, settings, (class_2794)referenceGenerator);
    }

    private static class_6880<class_5284> buildGeneratorSettings(class_6880<class_5284> reference, class_6880<class_5284> settings, class_1966 biomeSource) {
        return settings;
    }

    public static class_5284 amplifiedNether() {
        return new class_5284(NETHER_NOISE_SETTINGS_AMPLIFIED, class_2246.field_10515.method_9564(), class_2246.field_10164.method_9564(), class_6954.method_41211((class_2378)class_5458.field_37232, (class_6910)class_6954.method_42363((class_2378)class_5458.field_37232, (int)0, (int)256)), class_6725.method_39138(), List.of(), 32, false, false, false, true);
    }
}

